<?php
// app/views/panel/settings.php
$slug = tenant_slug();
$csrf = csrf_token();

$settings = $settings ?? []; // controller'dan geliyor varsayımı
$ok  = $ok  ?? null;
$err = $err ?? null;

function v($arr, $key, $default='') {
  return $arr[$key] ?? $default;
}

$localesEnabled = (string)v($settings,'locales_enabled','tr,en');
?>
<div class="flex items-center justify-between gap-3">
  <div>
    <h2 class="text-lg font-semibold">Ayarlar</h2>
    <p class="mt-1 text-sm text-slate-500 dark:text-slate-400">
      Panel davranışı, belge numarası, kargo, tema ve dil ayarları.
    </p>
  </div>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-4 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>

<?php if (!empty($err)): ?>
  <div class="mt-4 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<div class="mt-6 grid grid-cols-1 gap-4 lg:grid-cols-3">
  <!-- Tabs -->
  <div class="rounded-2xl border border-slate-200 p-3 dark:border-slate-800">
    <div class="text-xs font-semibold text-slate-500 dark:text-slate-400 px-2 py-2">Bölümler</div>

    <?php
      $tabs = [
        'general' => 'Genel',
        'docs'    => 'Belge No',
        'shipping'=> 'Kargo',
        'pdf'     => 'PDF / Yazdır',
        'theme'   => 'Tema',
        'lang'    => 'Dil',
      ];
      $active = (string)($_GET['tab'] ?? 'general');
      if (!isset($tabs[$active])) $active = 'general';
    ?>

    <div class="space-y-1">
      <?php foreach ($tabs as $k => $label): ?>
        <a href="<?= e(base_path('/'.$slug.'/settings?tab='.$k)) ?>"
           class="block rounded-xl px-3 py-2 text-sm border
           <?= $active===$k
             ? 'border-slate-300 bg-slate-50 text-slate-900 dark:border-slate-700 dark:bg-slate-900/40 dark:text-white'
             : 'border-transparent hover:bg-slate-50 dark:hover:bg-slate-900/30 text-slate-700 dark:text-slate-200'
           ?>">
          <?= e($label) ?>
        </a>
      <?php endforeach; ?>
    </div>

    <div class="mt-3 px-2 text-xs text-slate-500 dark:text-slate-400">
      Firma profili (logo/adres/vergi) için <a class="underline" href="<?= e(base_path('/'.$slug.'/company')) ?>">Firma Profili</a> sayfasını kullan.
    </div>
  </div>

  <!-- Form -->
  <div class="lg:col-span-2 rounded-2xl border border-slate-200 p-5 dark:border-slate-800">
    <form method="post" action="<?= e(base_path('/'.$slug.'/settings?tab='.$active)) ?>" class="space-y-6">
      <input type="hidden" name="csrf" value="<?= e($csrf) ?>">

      <?php if ($active === 'general'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm font-medium">Varsayılan Para Birimi</label>
            <input name="default_currency" value="<?= e((string)v($settings,'default_currency','TRY')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="TRY, USD, EUR">
          </div>

          <div>
            <label class="text-sm font-medium">Para Sembolü</label>
            <input name="default_currency_symbol" value="<?= e((string)v($settings,'default_currency_symbol','₺')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="₺, $, €">
          </div>

          <div>
            <label class="text-sm font-medium">Varsayılan KDV Oranı (%)</label>
            <input type="number" step="0.01" min="0" max="100"
                   name="default_vat_rate" value="<?= e((string)v($settings,'default_vat_rate','20')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
          </div>
                        <div>
                <label class="text-sm font-medium">Site Kısaltma (Header)</label>
                <input name="app_short" value="<?= e((string)($settings['app_short'] ?? 'FT')) ?>"
                        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                        placeholder="FT">
                </div>

                <div>
                <label class="text-sm font-medium">Site Adı (Header)</label>
                <input name="app_name" value="<?= e((string)($settings['app_name'] ?? 'FaturaTakip')) ?>"
                        class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                        placeholder="FaturaTakip">
                </div>

          <div>
            <label class="text-sm font-medium">Kayıt sonrası davranış</label>
            <select name="after_create_redirect"
                    class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
              <?php $acr = (string)v($settings,'after_create_redirect','view'); ?>
              <option value="view"  <?= $acr==='view'?'selected':'' ?>>Görüntüle sayfasına git</option>
              <option value="print" <?= $acr==='print'?'selected':'' ?>>Yazdır/PDF sayfasına git</option>
              <option value="list"  <?= $acr==='list'?'selected':'' ?>>Listeye dön</option>
            </select>
            <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">Belge oluşturduktan sonra nereye yönlendirileceğini belirler.</p>
          </div>
        </div>

      <?php elseif ($active === 'docs'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm font-medium">Fatura Prefix</label>
            <input name="invoice_prefix" value="<?= e((string)v($settings,'invoice_prefix','FTR-')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="FTR-">
          </div>

          <div>
            <label class="text-sm font-medium">Teklif Prefix</label>
            <input name="quote_prefix" value="<?= e((string)v($settings,'quote_prefix','TKL-')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="TKL-">
          </div>

          <div>
            <label class="text-sm font-medium">Sıfır Doldurma (padding)</label>
            <input type="number" min="1" max="12"
                   name="number_padding" value="<?= e((string)v($settings,'number_padding','6')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
            <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">Örn: 6 → 000001</p>
          </div>

          <div>
            <label class="text-sm font-medium">Sonraki Fatura No</label>
            <input type="number" min="1"
                   name="invoice_next_number" value="<?= e((string)v($settings,'invoice_next_number','1')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
          </div>

          <div>
            <label class="text-sm font-medium">Sonraki Teklif No</label>
            <input type="number" min="1"
                   name="quote_next_number" value="<?= e((string)v($settings,'quote_next_number','1')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
          </div>

          <div class="md:col-span-2 rounded-xl border border-slate-200 p-3 dark:border-slate-800">
            <div class="text-sm font-semibold">Örnek</div>
            <?php
              $pad = (int)v($settings,'number_padding',6);
              $inv = (string)v($settings,'invoice_prefix','FTR-') . str_pad((string)v($settings,'invoice_next_number',1), $pad, '0', STR_PAD_LEFT);
              $quo = (string)v($settings,'quote_prefix','TKL-') . str_pad((string)v($settings,'quote_next_number',1), $pad, '0', STR_PAD_LEFT);
            ?>
            <div class="mt-2 text-sm text-slate-600 dark:text-slate-300">
              Fatura örnek: <strong><?= e($inv) ?></strong><br>
              Teklif örnek: <strong><?= e($quo) ?></strong>
            </div>
          </div>
        </div>

      <?php elseif ($active === 'shipping'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="flex items-center gap-2">
            <?php $se = (int)v($settings,'shipping_enabled',1); ?>
            <input id="shipping_enabled" type="checkbox" name="shipping_enabled" value="1" <?= $se ? 'checked':'' ?>
                   class="h-4 w-4 rounded border-slate-300">
            <label for="shipping_enabled" class="text-sm font-medium">Kargo alanı aktif</label>
          </div>

          <div>
            <label class="text-sm font-medium">Varsayılan Kargo Modu</label>
            <?php $sm = (string)v($settings,'shipping_mode_default','separate'); ?>
            <select name="shipping_mode_default"
                    class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
              <option value="none"     <?= $sm==='none'?'selected':'' ?>>Kargo yok</option>
              <option value="separate" <?= $sm==='separate'?'selected':'' ?>>Kargo ayrı satır (toplamlara ekle)</option>
              <option value="line"     <?= $sm==='line'?'selected':'' ?>>Kargoyu kalem olarak ekle (item_type=shipping)</option>
            </select>
            <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">“line” seçilirse kargo kalemi olarak yazılır.</p>
          </div>

          <div>
            <label class="text-sm font-medium">Kargo KDV Oranı (%)</label>
            <input type="number" step="0.01" min="0" max="100"
                   name="shipping_vat_rate" value="<?= e((string)v($settings,'shipping_vat_rate','20')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
          </div>
        </div>

      <?php elseif ($active === 'pdf'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm font-medium">PDF / Yazdır Şablonu</label>
            <?php $pt = (string)v($settings,'pdf_template','modern'); ?>
            <select name="pdf_template"
                    class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
              <option value="modern" <?= $pt==='modern'?'selected':'' ?>>Modern</option>
              <option value="classic" <?= $pt==='classic'?'selected':'' ?>>Klasik</option>
              <option value="minimal" <?= $pt==='minimal'?'selected':'' ?>>Minimal</option>
            </select>
          </div>

          <div>
            <label class="text-sm font-medium">Dosya Adı Formatı</label>
            <input name="pdf_filename_pattern" value="<?= e((string)v($settings,'pdf_filename_pattern','{DOCNO} - {CUSTOMER}')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="{DOCNO} - {CUSTOMER}">
            <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">
              Değişkenler: <code>{DOCNO}</code>, <code>{CUSTOMER}</code>, <code>{DATE}</code>
            </p>
          </div>
        </div>

      <?php elseif ($active === 'theme'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm font-medium">Tema Modu</label>
            <?php $tm = (string)v($settings,'theme_mode','system'); ?>
            <select name="theme_mode"
                    class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
              <option value="system" <?= $tm==='system'?'selected':'' ?>>Sistem</option>
              <option value="light"  <?= $tm==='light'?'selected':'' ?>>Açık</option>
              <option value="dark"   <?= $tm==='dark'?'selected':'' ?>>Koyu</option>
            </select>
          </div>

          <div>
            <label class="text-sm font-medium">Ana Renk</label>
            <input name="theme_primary" value="<?= e((string)v($settings,'theme_primary','#0d6efd')) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="#0d6efd">
          </div>
        </div>

      <?php elseif ($active === 'lang'): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <label class="text-sm font-medium">Varsayılan Dil</label>
            <?php $ld = (string)v($settings,'locale_default','tr'); ?>
            <select name="locale_default"
                    class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
              <option value="tr" <?= $ld==='tr'?'selected':'' ?>>Türkçe</option>
              <option value="en" <?= $ld==='en'?'selected':'' ?>>English</option>
            </select>
          </div>

          <div>
            <label class="text-sm font-medium">Aktif Diller</label>
            <input name="locales_enabled"
                   value="<?= e($localesEnabled) ?>"
                   class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                   placeholder="tr,en">
            <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">Virgülle ayır: örn <code>tr,en</code></p>
          </div>
        </div>
      <?php endif; ?>

      <div class="flex items-center justify-end gap-2 pt-2">
        <button type="submit"
                class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">
          Kaydet
        </button>
      </div>
    </form>
  </div>
</div>
